/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : tichdefs.h
************************************************************************
* Written by    : Christoph chmidt, BID R&D, 6.7.98
* Last modified : ask clearcase
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef TICHDEFS_H_INCLUDED                               
#define TICHDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif



/* ---------------------------------------------------------------
 * Type Definitions for Timing Checker Functions
 * --------------------------------------------------------------- */

CLI typedef enum{
  B_TC_ACCUSIG1,    /* @accusig1  */
  B_TC_ACCUSIG2,    /* @accusig2  */
  B_TC_ACCUSIG3,    /* @accusig3  */
  B_TC_ACCUSIG4,    /* @accusig4  */
  B_TC_TCSTAT       /* @tcstat  */
} b_tcstatustype;


#define B_TCPROP_SIZE 4

CLI typedef enum {
  B_TC_HSIGN,           /* @hsign */
  B_TC_SETUP_TIME,      /* @setup */
  B_TC_HOLD_TIME,	/* @hold */
  B_TC_FREQUENCY        /* @freq */  
} b_tcproptype;

#define B_TCGENPROP_SIZE 1

CLI typedef enum {
  B_TCGEN_SPEC          /* @spec */  
} b_tcgenproptype;

/* The timing checker status register bits: */
#define B_TC_VIOLATION 0x1   /* OR-ed accu registers */
#define B_TC_ERROR     0x2   /* general error (calibration,BusSpeed,..) */

#endif


